<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Pais extends Model 
{

    protected $table = 'paises';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'code');
    protected $visible = array('name', 'code');

    public function distribuidoras()
    {
        return $this->belongsTo('Distribuidora', 'pais_id')->withTrashed();
    }

    public function taxes()
    {
        return $this->hasMany('Tax', 'pais_id')->withTrashed();
    }

}